package com.ejie.ab04b.service.nora;

import java.util.List;

import com.ejie.ab04b.model.nora.Municipio;

/**
 * MunicipioService.
 * 
 * @author GFI
 */
public interface MunicipioService {

	/**
	 * Finds a single row in the Municipio table.
	 * 
	 *  municipio
	 *            Municipio
	 *  Municipio
	 *
	 * @param municipio the municipio
	 * @return the municipio
	 */
	Municipio find(Municipio municipio);

	/**
	 * Finds a List of rows in the Municipio table.
	 * 
	 *  municipio
	 *            Municipio
	 *  List
	 *
	 * @param municipio the municipio
	 * @return the list
	 */
	List<Municipio> findAll(Municipio municipio);

	/**
	 * Counts rows in the Municipio table.
	 * 
	 *  municipio
	 *            Municipio
	 *  Long
	 *
	 * @param municipio the municipio
	 * @return the long
	 */
	Long findAllCount(Municipio municipio);

	/**
	 * Find all first.
	 *
	 * @param municipio the municipio
	 * @return the municipio
	 */
	Municipio findAllFirst(Municipio municipio);
}